#ifndef _CRECORDSET_CPP
#define _CRECORDSET_CPP
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <SQL.H>
#include <SqlExt.H>

#include "CSQL.H"
#include "CRecordSet.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CRecordSet::Close(void)
{
	bool bResult = 0;

	RowCount = 0;
	ColCount = 0;
	
	bResult = (SQLFreeHandle(SQL_HANDLE_STMT, hSTMT) == SQL_SUCCESS);

	hSTMT = NULL;

	return bResult;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CRecordSet::Fetch(void)
{
    if(SQL_SUCCEEDED(SQLFetch(hSTMT)))
	{
        return true;
	}
    else return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CRecordSet::GetData(SQLUSMALLINT iCol, SQLSMALLINT iType, SQLPOINTER pvBuf, SQLINTEGER iBufSz, SQLINTEGER *piOutBufSz)
{
    if(SQL_SUCCEEDED(SQLGetData(hSTMT, iCol, iType, pvBuf, iBufSz, piOutBufSz)))
	{
		return true;
	}
	else return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CRecordSet::GetColInfo(int iCol, char *sOutName, int iSzOfOutName, int *iOutColNameLen,
							int *ioutDataType, int *iOutColSize, int *iNumOfDeciPlaces, int *iColNullable)
{
	if(SQL_SUCCEEDED(SQLDescribeCol(hSTMT, iCol, (SQLCHAR *)sOutName, (SQLSMALLINT)iSzOfOutName,
		(SQLSMALLINT *)iOutColNameLen, (SQLSMALLINT *)ioutDataType, (SQLUINTEGER *)iOutColSize,
		(SQLSMALLINT *)iNumOfDeciPlaces, (SQLSMALLINT *)iColNullable)))
	{
		return true;
	}
	else return false;
}


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CRecordSet::sColumnEx(int iCol, char *sBuf, const int iBufSz, int *iOutLen)
{
	int iLen = 0;

	if(SQL_SUCCEEDED(SQLGetData(hSTMT, iCol, SQL_C_CHAR, sBuf, iBufSz, (SQLINTEGER *)&iLen)))
	{
		if(iOutLen)
		{
			*iOutLen = iLen;
		}
		
		return true;
	}

	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CRecordSet::lColumnEx(int iCol, long *plOutVal)
{
	long piOutBufSz = 0;

	if(SQL_SUCCEEDED(SQLGetData(hSTMT, iCol, SQL_C_LONG, plOutVal, sizeof(long), &piOutBufSz)))
	{
		return true;
	}
	else return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

long CRecordSet::lColumn(int iCol)
{
	long lTemp = 0;

	if(lColumnEx(iCol, &lTemp))
	{
	    return lTemp;
	}
	else return -1;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CRecordSet::dColumnEx(int iCol, double *pdOutVal)
{
	long piOutBufSz = 0;

	if(SQL_SUCCEEDED(SQLGetData(hSTMT, iCol, SQL_FLOAT, pdOutVal, sizeof(double), &piOutBufSz)))
	{
		return true;
	}
	else return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

double CRecordSet::dColumn(int iCol)
{
	double dTemp = 0;

	if(dColumnEx(iCol, &dTemp))
	{
	    return dTemp;
	}
	else return -1;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CRecordSet::fColumnEx(int iCol, float *pfOutVal)
{
	long piOutBufSz = 0;

	if(SQL_SUCCEEDED(SQLGetData(hSTMT, iCol, SQL_FLOAT, pfOutVal, sizeof(float), &piOutBufSz)))
	{
		return true;
	}
    else return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

float CRecordSet::fColumn(int iCol)
{
	float fTemp = 0;

	if(fColumnEx(iCol, &fTemp))
	{
	    return fTemp;
	}
	else return -1;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CRecordSet::CRecordSet()
{
	hSTMT = NULL;
	RowCount = 0;
	ColCount = 0;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CRecordSet::~CRecordSet()
{
	hSTMT = NULL;
	RowCount = 0;
	ColCount = 0;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
